﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.SharePoint;
using Microsoft.SharePoint.Utilities;

namespace AddNewItem
{
   class Program
   {
      static void Main(string[] args)
      {
         using (SPSite site = new SPSite("http://contoso.de"))
         {
            using (SPWeb web = site.OpenWeb())
            {
               // Hole die Kundenreferenz               
               SPList listCustomer = web.Lists.TryGetList("Kunden");               
               SPListItem anyCustomer = listCustomer.GetItemById(1);

               // Hole die Artikelreferenz
               SPList listArticle = web.Lists.TryGetList("Artikel");
               SPListItem anyArticle = listArticle.GetItemById(1);

               // Hole eine Referenz der Bestellliste
               SPList listOrders = web.Lists.TryGetList("Bestellungen");

               // Erstelle ein neues Element
               SPListItem newItem = listOrders.AddItem();
               newItem["Title"] = Guid.NewGuid();
               newItem["Kunde"] = anyCustomer.ID;
               newItem["Artikel"] = anyArticle.ID;
               newItem["Menge"] = 1;
               newItem["Liefertermin"] =
                  SPUtility.CreateISO8601DateTimeFromSystemDateTime(
                  DateTime.Now);
               newItem.Update();

               Console.WriteLine("Element erstellt: {0} ({1})", 
                  newItem.Title, newItem["Created"].ToString());               
            }
         }
      }
   }
}
